<?php

if(!function_exists('hudson_edge_is_responsive_on')) {
    /**
     * Checks whether responsive mode is enabled in theme options
     * @return bool
     */
    function hudson_edge_is_responsive_on() {
        global $hudson_edge_options;

        return isset($hudson_edge_options['responsiveness']) && $hudson_edge_options['responsiveness'] !== 'no';
    }
}

if(!function_exists('hudson_edge_is_seo_enabled')) {
    /**
     * Checks if SEO is enabled in theme options
     * @return bool
     */
    function hudson_edge_is_seo_enabled() {
        global $hudson_edge_options;

        return isset($hudson_edge_options['disable_edgt_seo']) && $hudson_edge_options['disable_edgt_seo'] == 'no';
    }
}

if(!function_exists('hudson_edge_get_header_variables')) {
    function hudson_edge_get_header_variables() {
        global $hudson_edge_options;

        //init variables
        $id = hudson_edge_get_page_id();
        $loading_animation = true;
        $loading_image =  "";
        $enable_side_area = "yes";
        $enable_popup_menu = "no";
        $popup_menu_animation_style = '';
        $enable_fullscreen_search = "no";
        $fullscreen_search_animation = "fade";
        $header_button_size = '';
        $paspartu_header_alignment = false;
        $header_in_grid = true;
        $header_bottom_class = ' header_in_grid';
        $menu_item_icon_position = "";
        $menu_position = "";
        $centered_logo = hudson_edge_is_logo_centered();
        $enable_border_top_bottom_menu = false;
        $menu_dropdown_appearance_class = "";
        $logo_wrapper_style = "";
        $divided_left_menu_padding = "";
        $divided_right_menu_padding = "";
        $display_header_top = "yes";
        $header_top_area_scroll = "no";
        $header_style = hudson_edge_get_header_style();
        $header_color_transparency_per_page = hudson_edge_get_header_transparency();
        $header_color_per_page = "";
        $header_top_color_per_page = "";
        $header_color_transparency_on_scroll = "";
        $header_bottom_border_style = '';
        $header_bottom_appearance = 'fixed';
        $header_transparency = '';
        $enable_vertical_menu = false;
        $enable_search_left_sidearea_right = false;
        $vertical_area_background_image = "";
        $vertical_menu_style = "toggle";
        $vertical_area_scroll = " with_scroll";
        $page_vertical_area_background_transparency = "";
        $page_vertical_area_background = "";

        if (isset($hudson_edge_options['loading_animation'])) {
            if($hudson_edge_options['loading_animation'] == "off") {
                $loading_animation = false;
            }
        }

        if (isset($hudson_edge_options['loading_image']) && $hudson_edge_options['loading_image'] != "") {
            $loading_image = $hudson_edge_options['loading_image'];
        }

        if (isset($hudson_edge_options['enable_side_area'])) {
            if($hudson_edge_options['enable_side_area'] == "no" || ! is_active_sidebar('sidearea')) {
                $enable_side_area = "no";
            }
        }

        if (isset($hudson_edge_options['enable_popup_menu'])) {
            if($hudson_edge_options['enable_popup_menu'] == "yes" && has_nav_menu('popup-navigation')) {
                $enable_popup_menu = "yes";
            }

            if (isset($hudson_edge_options['popup_menu_animation_style']) && !empty($hudson_edge_options['popup_menu_animation_style'])) {
                $popup_menu_animation_style = $hudson_edge_options['popup_menu_animation_style'];
            }
        }

        if(isset($hudson_edge_options['enable_search']) && $hudson_edge_options['enable_search'] == "yes" && isset($hudson_edge_options['search_type']) && $hudson_edge_options['search_type'] == "fullscreen_search" ){
            $enable_fullscreen_search="yes";
        }

        if(isset($hudson_edge_options['search_type']) && $hudson_edge_options['search_type'] == "fullscreen_search" && isset($hudson_edge_options['search_animation']) && $hudson_edge_options['search_animation'] !== "" ){
            $fullscreen_search_animation = $hudson_edge_options['search_animation'];
        }

        if(isset($hudson_edge_options['header_buttons_size'])){
            $header_button_size = $hudson_edge_options['header_buttons_size'];
        }

        if(isset($hudson_edge_options['paspartu_header_alignment'])
            && $hudson_edge_options['paspartu_header_alignment'] == 'yes'
            && isset($hudson_edge_options['paspartu'])
            && $hudson_edge_options['paspartu'] == 'yes') {
            $paspartu_header_alignment = true;
        }

        if ($hudson_edge_options['header_in_grid'] == "no" || $paspartu_header_alignment){
            $header_in_grid = false;
        }

        if($header_in_grid) {
            $header_bottom_class = ' header_in_grid';
        } else {
            $header_bottom_class = ' header_full_width';
        }

        if(isset($hudson_edge_options['menu_item_icon_position'])) {
            $menu_item_icon_position = $hudson_edge_options['menu_item_icon_position'];
        }

        if(isset($hudson_edge_options['menu_position'])) {
            $menu_position = $hudson_edge_options['menu_position'];
        }


        if(isset($hudson_edge_options['enable_border_top_bottom_menu']) && $hudson_edge_options['enable_border_top_bottom_menu'] == "yes") {
            $enable_border_top_bottom_menu = true;
        }

        if(isset($hudson_edge_options['menu_dropdown_appearance']) && $hudson_edge_options['menu_dropdown_appearance'] != "default"){
            $menu_dropdown_appearance_class = $hudson_edge_options['menu_dropdown_appearance'];
        }

        if(isset($hudson_edge_options['header_bottom_appearance']) && $hudson_edge_options['header_bottom_appearance'] == "stick_with_left_right_menu"){
            $logo_wrapper_style = 'width:'.(esc_attr($hudson_edge_options['logo_width'])/2).'px;';
            $divided_left_menu_padding = 'padding-right:'.(esc_attr($hudson_edge_options['logo_width'])/4).'px;';
            $divided_right_menu_padding = 'padding-left:'.(esc_attr($hudson_edge_options['logo_width'])/4).'px;';
        }

        if($hudson_edge_options['center_logo_image'] == "yes" && $hudson_edge_options['header_bottom_appearance'] == "regular"){
            $logo_wrapper_style = 'height:'.(esc_attr($hudson_edge_options['logo_height'])/2).'px;';
        }

        if(isset($hudson_edge_options['header_bottom_appearance']) && $hudson_edge_options['header_bottom_appearance'] == "fixed_top_header"){
            $logo_wrapper_style = 'height:'.(esc_attr($hudson_edge_options['logo_height'])/2).'px;';
        }

        if(isset($hudson_edge_options['header_top_area'])){
            $display_header_top = $hudson_edge_options['header_top_area'];
        }

        if(isset($hudson_edge_options['header_top_area_scroll'])){
            $header_top_area_scroll = $hudson_edge_options['header_top_area_scroll'];
        }

        if(get_post_meta($id, "edgt_header_color_per_page", true) != ""){
            if($header_color_transparency_per_page != ""){
                $header_background_color = hudson_edge_hex2rgb(esc_attr(get_post_meta($id, "edgt_header_color_per_page", true)));
                $header_color_per_page .= "background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . $header_color_transparency_per_page . ");";
            }else{
                $header_color_per_page .= "background-color:" . esc_attr(get_post_meta($id, "edgt_header_color_per_page", true)) . ";";
            }
        } else if($header_color_transparency_per_page != "" && get_post_meta($id, "edgt_header_color_per_page", true) == ""){
            $header_background_color = $hudson_edge_options['header_background_color'] ? hudson_edge_hex2rgb(esc_attr($hudson_edge_options['header_background_color'])) : hudson_edge_hex2rgb("#ffffff");
            $header_color_per_page .= "background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . $header_color_transparency_per_page . ");";
        }

        if(isset($hudson_edge_options['header_botom_border_in_grid']) && $hudson_edge_options['header_botom_border_in_grid'] != "yes" && get_post_meta($id, "edgt_header_bottom_border_color", true) != ""){
            $header_color_per_page .= "border-bottom: 1px solid ".esc_attr(get_post_meta($id, "edgt_header_bottom_border_color", true)).";";
        }

        if(get_post_meta($id, "edgt_header_color_per_page", true) != ""){
            if($header_color_transparency_per_page != ""){
                $header_background_color = hudson_edge_hex2rgb(esc_attr(get_post_meta($id, "edgt_header_color_per_page", true)));
                $header_top_color_per_page .= "background-color:rgba(" . esc_attr($header_background_color[0]) . ", " . esc_attr($header_background_color[1]) . ", " . esc_attr($header_background_color[2]) . ", " . esc_attr($header_color_transparency_per_page) . ");";
            }else{
                $header_top_color_per_page .= "background-color:" . esc_attr(get_post_meta($id, "edgt_header_color_per_page", true)) . ";";
            }
        } else if($header_color_transparency_per_page != "" && get_post_meta($id, "edgt_header_color_per_page", true) == ""){
            $header_background_color = $hudson_edge_options['header_top_background_color'] ? hudson_edge_hex2rgb(esc_attr($hudson_edge_options['header_top_background_color'])) : hudson_edge_hex2rgb("#ffffff");
            $header_top_color_per_page .= "background-color:rgba(" . esc_attr($header_background_color[0]) . ", " . esc_attr($header_background_color[1]) . ", " . esc_attr($header_background_color[2]) . ", " . esc_attr($header_color_transparency_per_page) . ");";
        }

        if(isset($hudson_edge_options['header_background_transparency_sticky']) && $hudson_edge_options['header_background_transparency_sticky'] != ""){
            $header_color_transparency_on_scroll = $hudson_edge_options['header_background_transparency_sticky'];
        }

        if(isset($hudson_edge_options['header_botom_border_in_grid']) && $hudson_edge_options['header_botom_border_in_grid'] == "yes" && get_post_meta($id, "edgt_header_bottom_border_color", true) != ""){
            $header_bottom_border_style = 'border-bottom: 1px solid '.esc_attr(get_post_meta($id, "edgt_header_bottom_border_color", true)).';';
        }

        if(isset($hudson_edge_options['header_bottom_appearance'])){
            $header_bottom_appearance = $hudson_edge_options['header_bottom_appearance'];
        }

        $per_page_header_transparency = esc_attr(get_post_meta($id, 'edgt_header_color_transparency_per_page', true));
        if($per_page_header_transparency !== '' && $per_page_header_transparency !== false) {
            $header_transparency = $per_page_header_transparency;
        } else {
            $header_transparency = esc_attr($hudson_edge_options['header_background_transparency_initial']);
        }

        if(hudson_edge_is_side_header()){
            $enable_vertical_menu = true;
        }

        if(isset($hudson_edge_options['header_bottom_appearance']) && $hudson_edge_options['header_bottom_appearance'] =='fixed_hiding'){
            if(isset($hudson_edge_options['search_left_sidearea_right']) && $hudson_edge_options['search_left_sidearea_right'] =='yes'){
                $enable_search_left_sidearea_right = true;
            }
        }else{
            if(isset($hudson_edge_options['search_left_sidearea_right_regular']) && $hudson_edge_options['search_left_sidearea_right_regular'] =='yes'){
                $enable_search_left_sidearea_right = true;
            }
        }

        if(isset($hudson_edge_options['vertical_area_background_image']) && $hudson_edge_options['vertical_area_background_image'] != "" && isset($hudson_edge_options['vertical_area_dropdown_showing']) && $hudson_edge_options['vertical_area_dropdown_showing'] != "side" && get_post_meta($id, "edgt_page_disable_vertical_area_background_image", true) != "yes") {
            $vertical_area_background_image = $hudson_edge_options['vertical_area_background_image'];
        }
        if(get_post_meta($id, "edgt_page_vertical_area_background_image", true) != "" && get_post_meta($id, "edgt_page_disable_vertical_area_background_image", true) != "yes" && isset($hudson_edge_options['vertical_area_dropdown_showing']) && $hudson_edge_options['vertical_area_dropdown_showing'] != "side"){
            $vertical_area_background_image = get_post_meta($id, "edgt_page_vertical_area_background_image", true);
        }

        $vertical_area_dropdown_showing = $hudson_edge_options['vertical_area_dropdown_showing'];
		
		if(isset($hudson_edge_options['vertical_area_nav_in_middle']) && $hudson_edge_options['vertical_area_nav_in_middle']=="yes"){
			$vertical_menu_style = 'to_content';
		}
		else{
			switch($vertical_area_dropdown_showing){
				case 'hover':
					$vertical_menu_style = "toggle";
					break;
				case 'click':
					$vertical_menu_style = "toggle click";
					break;
				case 'side':
					$vertical_menu_style = "side";
					break;
				case 'to_content':
					$vertical_menu_style = "to_content";
					break;
				default:
					$vertical_menu_style = "toggle";

			}
		}
		
        $vertical_area_scroll = " with_scroll";
        if ($vertical_area_dropdown_showing == 'to_content') {
            $vertical_area_scroll = "";
        }

        if(isset($hudson_edge_options['paspartu']) && $hudson_edge_options['paspartu'] == 'yes' && isset($hudson_edge_options['vertical_menu_inside_paspartu']) && $hudson_edge_options['vertical_menu_inside_paspartu'] == 'yes'){
            if($hudson_edge_options['vertical_area_background_transparency'] != "") {
                $page_vertical_area_background_transparency = esc_attr($hudson_edge_options['vertical_area_background_transparency']);
            }
            if(get_post_meta($id, "edgt_page_vertical_area_background_opacity", true) != ""){
                $page_vertical_area_background_transparency = esc_attr(get_post_meta($id, "edgt_page_vertical_area_background_opacity", true));
            }

            if(isset($hudson_edge_options['vertical_area_dropdown_showing']) && $hudson_edge_options['vertical_area_dropdown_showing'] == "side"){
                $page_vertical_area_background_transparency = 1;
            }
        }
        else if(isset($hudson_edge_options['paspartu']) && $hudson_edge_options['paspartu'] == 'no') {
            if($hudson_edge_options['vertical_area_background_transparency'] != "") {
                $page_vertical_area_background_transparency = esc_attr($hudson_edge_options['vertical_area_background_transparency']);
            }
            if(get_post_meta($id, "edgt_page_vertical_area_background_opacity", true) != ""){
                $page_vertical_area_background_transparency = esc_attr(get_post_meta($id, "edgt_page_vertical_area_background_opacity", true));
            }

            if(isset($hudson_edge_options['vertical_area_dropdown_showing']) && $hudson_edge_options['vertical_area_dropdown_showing'] == "side"){
                $page_vertical_area_background_transparency = 1;
            }
        }

        if(get_post_meta($id, "edgt_page_vertical_area_background", true) != ""){
            $page_vertical_area_background =esc_attr(get_post_meta($id, 'edgt_page_vertical_area_background', true));

        }else if(get_post_meta($id, "edgt_page_vertical_area_background", true) == ""){
            $page_vertical_area_background = $hudson_edge_options['vertical_area_background'];
        }

        $bkg_image="";
        $page_vertical_area_background_style = "";
        $page_vertical_area_background_transparency_style = "";
        if($vertical_area_background_image != ""){ $bkg_image = 'background-image:url('.esc_url($vertical_area_background_image).');'; }
        if($page_vertical_area_background != ""){ $page_vertical_area_background_style = 'background-color:'.esc_attr($page_vertical_area_background).';'; }
        if($page_vertical_area_background_transparency != ""){ $page_vertical_area_background_transparency_style = 'opacity:'.esc_attr($page_vertical_area_background_transparency).';'; }

        $vertical_area_menu_items_arrow = '';
        if (isset($hudson_edge_options['vertical_area_menu_items_arrow']) && $hudson_edge_options['vertical_area_menu_items_arrow'] =='yes' ){
            $vertical_area_menu_items_arrow = 'with_arrow';
        }

        return array(
            'id' => $id,
            'loading_animation' => $loading_animation,
            'loading_image' => $loading_image,
            'enable_side_area' => $enable_side_area,
            'enable_popup_menu' => $enable_popup_menu,
            'popup_menu_animation_style' => $popup_menu_animation_style,
            'enable_fullscreen_search' => $enable_fullscreen_search,
            'fullscreen_search_animation' => $fullscreen_search_animation,
            'header_button_size' => $header_button_size,
            'header_in_grid' => $header_in_grid,
            'header_bottom_class' => $header_bottom_class,
            'menu_item_icon_position' => $menu_item_icon_position,
            'menu_position' => $menu_position,
            'centered_logo' => $centered_logo,
            'enable_border_top_bottom_menu' => $enable_border_top_bottom_menu,
            'menu_dropdown_appearance_class' => $menu_dropdown_appearance_class,
            'logo_wrapper_style' => $logo_wrapper_style,
            'divided_left_menu_padding' => $divided_left_menu_padding,
            'divided_right_menu_padding' => $divided_right_menu_padding,
            'display_header_top' => $display_header_top,
            'header_top_area_scroll' => $header_top_area_scroll,
            'header_style' => $header_style,
            'header_color_transparency_per_page' => $header_color_transparency_per_page,
            'header_color_per_page' => $header_color_per_page,
            'header_top_color_per_page' => $header_top_color_per_page,
            'header_color_transparency_on_scroll' => $header_color_transparency_on_scroll,
            'header_bottom_border_style' => $header_bottom_border_style,
            'header_bottom_appearance' => $header_bottom_appearance,
            'header_transparency' => $header_transparency,
            'enable_vertical_menu' => $enable_vertical_menu,
            'enable_search_left_sidearea_right' => $enable_search_left_sidearea_right,
            'vertical_area_background_image' => $vertical_area_background_image,
            'vertical_menu_style' => $vertical_menu_style,
            'vertical_area_scroll' => $vertical_area_scroll,
            'page_vertical_area_background_transparency' => $page_vertical_area_background_transparency,
            'page_vertical_area_background' => $page_vertical_area_background,
            'bkg_image' => $bkg_image,
            'page_vertical_area_background_style' => $page_vertical_area_background_style,
            'page_vertical_area_background_transparency_style' => $page_vertical_area_background_transparency_style,
            'vertical_area_menu_items_arrow' => $vertical_area_menu_items_arrow
        );
    }
}

if(!function_exists('hudson_edge_get_footer_variables')) {
    function hudson_edge_get_footer_variables() {
        global $hudson_edge_options;

        $id = hudson_edge_get_page_id();

        $footer_border_columns				= 'yes';
        $footer_top_border_color            = '';
        $footer_top_border_in_grid          = '';
        $footer_bottom_border_in_grid       = '';
        $footer_bottom_border_color         = '';
        $footer_bottom_border_bottom_color  = '';
        $footer_classes                     = '';
        $footer_classes_array               = array();
        $footer_in_grid                     = true;
        $display_footer_top                 = true;
        $footer_top_columns                 = 4;
        $footer_bottom_columns              = 3;

        if(isset($hudson_edge_options['footer_border_columns']) && $hudson_edge_options['footer_border_columns'] !== '') {
            $footer_border_columns = $hudson_edge_options['footer_border_columns'];
        }

        if(!empty($hudson_edge_options['footer_top_border_color'])) {
            if (isset($hudson_edge_options['footer_top_border_width']) && $hudson_edge_options['footer_top_border_width'] !== '') {
                $footer_border_height = $hudson_edge_options['footer_top_border_width'];
            } else {
                $footer_border_height = '1';
            }

            $footer_top_border_color = 'height: '.esc_attr($footer_border_height).'px;background-color: '.esc_attr($hudson_edge_options['footer_top_border_color']).';';
        }

        if(isset($hudson_edge_options['footer_top_border_in_grid']) && $hudson_edge_options['footer_top_border_in_grid'] == 'yes') {
            $footer_top_border_in_grid = 'in_grid';
        }

        if(isset($hudson_edge_options['footer_bottom_border_in_grid']) && $hudson_edge_options['footer_bottom_border_in_grid'] == 'yes') {
            $footer_bottom_border_in_grid = 'in_grid';
        }

        if(!empty($hudson_edge_options['footer_bottom_border_color'])) {
            if(!empty($hudson_edge_options['footer_bottom_border_width'])) {
                $footer_bottom_border_width = $hudson_edge_options['footer_bottom_border_width'].'px';
            }
            else{
                $footer_bottom_border_width = '1px';
            }

            $footer_bottom_border_color = 'height: '.esc_attr($footer_bottom_border_width).';background-color: '.esc_attr($hudson_edge_options['footer_bottom_border_color']).';';
        }


        if(!empty($hudson_edge_options['footer_bottom_border_bottom_color'])) {
            if(!empty($hudson_edge_options['footer_bottom_border_bottom_width'])) {
                $footer_bottom_border_bottom_width = $hudson_edge_options['footer_bottom_border_bottom_width'].'px';
            } else {
                $footer_bottom_border_bottom_width = '1px';
            }

            $footer_bottom_border_bottom_color = 'height: '.esc_attr($footer_bottom_border_bottom_width).';background-color: '.esc_attr($hudson_edge_options['footer_bottom_border_bottom_color']).';';
        }

        //is uncovering footer option set in theme options?
        if(isset($hudson_edge_options['uncovering_footer']) && $hudson_edge_options['uncovering_footer'] == "yes" && isset($hudson_edge_options['paspartu']) && $hudson_edge_options['paspartu'] == 'no') {
            //add uncovering footer class to array
            $footer_classes_array[] = 'uncover';
        }


        if(get_post_meta($id, "edgt_footer-disable", true) == "yes"){
            $footer_classes_array[] = 'disable_footer';
        }

        if($footer_border_columns == 'yes') {
            $footer_classes_array[] = 'footer_border_columns';
        }

        if(isset($hudson_edge_options['paspartu']) && $hudson_edge_options['paspartu'] == 'yes' && isset($hudson_edge_options['paspartu_footer_alignment']) && $hudson_edge_options['paspartu_footer_alignment'] == 'yes'){
            $footer_classes_array[]= 'paspartu_footer_alignment';
        }

        if($hudson_edge_options['overlapping_content'] == 'yes' && $hudson_edge_options['overlapping_bottom_content_amount'] !== "") {
            $footer_classes_array[]= 'footer_overlapped';
        }

        //is some class added to footer classes array?
        if(is_array($footer_classes_array) && count($footer_classes_array)) {
            //concat all classes and prefix it with class attribute
            $footer_classes = esc_attr(implode(' ', $footer_classes_array));
        }

        if(isset($hudson_edge_options['footer_in_grid'])){
            if ($hudson_edge_options['footer_in_grid'] != "yes") {
                $footer_in_grid = false;
            }
        }

        if (isset($hudson_edge_options['show_footer_top']) && $hudson_edge_options['show_footer_top'] == "no") {
            $display_footer_top = false;
        }

        if (isset($hudson_edge_options['footer_top_columns'])) {
            $footer_top_columns = $hudson_edge_options['footer_top_columns'];
        }

        if (isset($hudson_edge_options['footer_bottom_columns'])) {
            $footer_bottom_columns = $hudson_edge_options['footer_bottom_columns'];
        }

        return array(
            'footer_border_columns' => $footer_border_columns,
            'footer_top_border_color' => $footer_top_border_color,
            'footer_top_border_in_grid' => $footer_top_border_in_grid,
            'footer_bottom_border_in_grid' => $footer_bottom_border_in_grid,
            'footer_bottom_border_color' => $footer_bottom_border_color,
            'footer_bottom_border_bottom_color' => $footer_bottom_border_bottom_color,
            'footer_classes' => $footer_classes,
            'footer_in_grid' => $footer_in_grid,
            'display_footer_top' => $display_footer_top,
            'footer_top_columns' => $footer_top_columns,
            'footer_bottom_columns' => $footer_bottom_columns
        );
    }
}

if(!function_exists('hudson_edge_is_logo_centered')) {
    /**
     * Checks if logo is centered or not
     * @return bool
     */
    function hudson_edge_is_logo_centered() {
        global $hudson_edge_options;

        $centered_logo = false;

        if (isset($hudson_edge_options['center_logo_image'])) {
            if($hudson_edge_options['center_logo_image'] == "yes" && $hudson_edge_options['header_bottom_appearance'] !== "stick_with_left_right_menu") {
                $centered_logo = true;
            }
        }

        if(isset($hudson_edge_options['header_bottom_appearance']) && $hudson_edge_options['header_bottom_appearance'] == "fixed_hiding"){
            $centered_logo = true;
        }

        return $centered_logo;
    }
}

if(!function_exists('hudson_edge_get_header_style')) {
    /**
     * Returns current page header style. It first checks in current page meta field,
     * if that isn't set it checks in global options
     * @return mixed|string
     */
    function hudson_edge_get_header_style() {
        global $hudson_edge_options;

        $id = hudson_edge_get_page_id();
        $header_style = '';

        if(get_post_meta($id, "edgt_header-style", true) != "") {
            $header_style = get_post_meta($id, "edgt_header-style", true);
        } elseif(isset($hudson_edge_options['header_style'])) {
            $header_style = $hudson_edge_options['header_style'];
        }

        return $header_style;
    }
}

if(!function_exists('hudson_edge_get_header_transparency')) {
    /**
     * Returns current page's header transparency. First it checks in current page custom field,
     * if not set it checks in global options
     * @return mixed|string
     */
    function hudson_edge_get_header_transparency() {
        global $hudson_edge_options;

        $id = hudson_edge_get_page_id();
        $header_color_transparency_per_page = '';


        if(get_post_meta($id, "edgt_header_color_transparency_per_page", true) != ""){
            $header_color_transparency_per_page = get_post_meta($id, "edgt_header_color_transparency_per_page", true);
        } elseif($hudson_edge_options['header_background_transparency_initial'] != "") {
            $header_color_transparency_per_page = $hudson_edge_options['header_background_transparency_initial'];
        }

        return $header_color_transparency_per_page;
    }
}

if(!function_exists('hudson_edge_is_top_header')) {
    /**
     * Checks if header type is top
     * @return bool
     */
    function hudson_edge_is_top_header() {
        global $hudson_edge_options;

		$top_header = false;
		
        if($hudson_edge_options['header_type'] == "top") {
            $top_header = true;
        }

        return $top_header;
    }
}

if(!function_exists('hudson_edge_is_side_header')) {
    /**
     * Checks if header type is side
     * @return bool
     */
    function hudson_edge_is_side_header() {
        global $hudson_edge_options;

		$side_header = false;
		
        if($hudson_edge_options['header_type'] == "side") {
            $side_header = true;
        }

        return $side_header;
    }
}

if(!function_exists('hudson_edge_is_ribbon_header')) {
    /**
     * Checks if header type is ribbon
     * @return bool
     */
    function hudson_edge_is_ribbon_header() {
        global $hudson_edge_options;

		$ribbon_header = false;
		
        if($hudson_edge_options['header_type'] == "ribbon") {
            $ribbon_header = true;
        }

        return $ribbon_header;
    }
}

if(!function_exists('hudson_edge_space_around_content')) {
    /**
     * Checks if there is spacing around content
     * @return bool
     */
    function hudson_edge_space_around_content() {
        global $hudson_edge_options;

        $space_around_content = false;

        if($hudson_edge_options['boxed'] == "yes" && $hudson_edge_options['spacing_arround_content'] == "yes") {
            $space_around_content = true;
        }

        return $space_around_content;
    }
}

if(!function_exists('hudson_edge_include_footer_in_content')) {
    /**
     * Checks if footer is included in spacing
     * @return bool
     */
    function hudson_edge_include_footer_in_content() {
        global $hudson_edge_options;

        $include_footer_in_content = false;

        if($hudson_edge_options['boxed'] == "yes" && $hudson_edge_options['spacing_arround_content'] == "yes" && $hudson_edge_options['footer_in_content'] == "yes") {
            $include_footer_in_content = true;
        }

        return $include_footer_in_content;
    }
}